// Copyright ® 2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import Foundation

enum CameraManagerError: LocalizedError {
    case cameraUnavailable
    case cannotAddInput
    case cannotAddOutput
    case cameraInputFailure(Error)
    case deniedAuthorization
    case restrictedAuthorization
    case unknownAuthorization
    case inputSetupFail
    case captureSessionSetupFail
    
    var errorDescription: String? {
        switch self {
            case .cameraUnavailable:
                return "Camera unavailable"
            case .cannotAddInput:
                return "Cannot add capture input to session"
            case .cannotAddOutput:
                return "Cannot add video output to session"
            case .cameraInputFailure(let error):
                return "Failed creating capture input for camera: \(error.localizedDescription)"
            case .deniedAuthorization:
                return "Camera access denied"
            case .restrictedAuthorization:
                return "Attempting to access a restricted capture device"
            case .unknownAuthorization:
                return "Unknown authorization status for capture device"
            case .inputSetupFail:
                return "Input device setup failed"
            case .captureSessionSetupFail:
                return "Capture session setup failed"
        }
    }
}
